/*********************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.       *
* Any unauthorized use,  reproduction or transfer of this program is strictly    *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.          *
*********************************************************************************/
`delay_mode_path
`timescale 1ns / 1ns
`ifdef SYNTH
`else
`celldefine
`endif
module csdpram (qa, qb, busy, clock, clockx2, wea, web, dataa, datab, addressa, addressb);

  parameter lpm_type = "csdpram" ;
  parameter lpm_width  = 8 ;
  parameter lpm_widthad = 3 ;
  parameter lpm_numwords = 8 ;
  parameter lpm_file = "UNUSED" ;
  parameter polar_dataa      = "NORMAL" ;
  parameter polar_datab      = "NORMAL" ;
  parameter polar_wea        = "NORMAL" ;
  parameter polar_web        = "NORMAL" ;
  parameter polar_clock      = "NORMAL" ;
  parameter polar_clockx2    = "NORMAL" ;
  parameter polar_addressa   = "NORMAL" ;
  parameter polar_addressb   = "NORMAL" ;
  parameter polar_qa         = "NORMAL" ;
  parameter polar_qb         = "NORMAL" ;
  parameter polar_busy       = "NORMAL" ;

input [lpm_width-1:0] dataa;
input [lpm_width-1:0] datab;
input [lpm_widthad-1:0] addressa;
input [lpm_widthad-1:0] addressb;
input wea;
input web;
input clock;
input clockx2;
output [lpm_width-1:0] qa;
output [lpm_width-1:0] qb;
output busy;


// internal reg
reg [lpm_width-1:0] mem_data [lpm_numwords-1:0];
reg [lpm_width-1:0] tmp_a;
reg tmp_busy;
reg [lpm_width-1:0] pdataa;
reg [lpm_width-1:0] pdatab;
reg [lpm_widthad-1:0] paddressa;
reg [lpm_widthad-1:0] paddressb;
reg pwea;
reg pweb;
reg pclock;
reg pclockx2;
reg [lpm_width-1:0] UNKNOWN;
reg [lpm_width-1:0] ZEROS;
reg [lpm_width-1:0] clocked_dataa;
reg [lpm_width-1:0] clocked_datab;
reg [lpm_width-1:0] muxed_data;
reg [lpm_widthad-1:0] muxed_address;
reg [lpm_widthad-1:0] clocked_addressa;
reg [lpm_widthad-1:0] clocked_addressb;
reg clocked_wea;
reg clocked_web;
reg [8*256:1] mem_initf;
reg muxed_we;
integer i;

// pragma translate_off
function ValidAddress;
    input [lpm_widthad-1:0] paddress;
    begin
        ValidAddress = 1'b0;
        if(^paddress ==='bx)
              $display("%d:Error: Invalid address.", $time);
        else if(paddress >= lpm_numwords)
              $display("%d:Error: Address out of bound on RAM.", $time);
        else
              ValidAddress = 1'b1;
    end
endfunction

initial
begin

  // check for number of words out of bound
   if(lpm_numwords > (1 << lpm_widthad))
         $display("Error! Too many words defined.");

   for (i=0; i < lpm_width; i=i+1)
      begin
          UNKNOWN[i] = 1'bX;
          ZEROS[i] = 1'b0;
      end

   tmp_a = ZEROS;
   tmp_busy = 0;

   for(i = 0; i < lpm_numwords; i=i+1)
         mem_data[i] = ZEROS;

  // load data to the RAM
   if (lpm_file != "UNUSED")
      begin
`ifdef SYNTH
`else
           $convert_hex2ver(lpm_file, lpm_width, mem_initf);
`endif
           $readmemh(mem_initf, mem_data);
      end
end

  always @(dataa )
    pdataa    <= #1 (polar_dataa == "INVERT")?~dataa:dataa;

  always @(datab )
    pdatab    <= #1 (polar_datab == "INVERT")?~datab:datab;

  always @(addressa)
      paddressa <= #1 (polar_addressa == "INVERT")?~addressa:addressa;
 
  always @(addressb)
      paddressb <= #1 (polar_addressb == "INVERT")?~addressb:addressb;
 
  always @(wea)
      pwea <= #1 (polar_wea == "INVERT")?~wea:wea;
 
  always @(web)
      pweb <= #1 (polar_web == "INVERT")?~web:web;
 
  always @(clock)
      pclock <= #1 (polar_clock == "INVERT")?~clock:clock;
 
  always @(clockx2)
      pclockx2 <= #1 (polar_clockx2 == "INVERT")?~clockx2:clockx2;
    

  always @( posedge pclock)
     begin 
         clocked_addressa = paddressa;
         clocked_addressb = paddressb;
         clocked_dataa = pdataa;
         clocked_datab = pdatab;
         clocked_wea = pwea;
         clocked_web = pweb;

         if (clocked_wea)
             begin
                 if (clocked_addressb == clocked_addressa)
                     tmp_busy = 1;
                 else
                     tmp_busy = 0;
             end
         else
             tmp_busy = 0;
     end

  always @( negedge pclock)
     begin 
         if (!clocked_wea )
               tmp_a = mem_data[clocked_addressa];
     end

  always @( posedge pclockx2)
     begin
         if (pclock)
             begin
                 muxed_address = clocked_addressa;
                 muxed_data = clocked_dataa;
                 muxed_we = clocked_wea;
             end
         else
             begin
                 muxed_address = clocked_addressb;
                 muxed_data = clocked_datab;
                 muxed_we = clocked_web;
             end

         if (muxed_we) 
             begin
                if(ValidAddress(muxed_address))
                     mem_data[muxed_address] = muxed_data;
                else
                     mem_data[muxed_address] = UNKNOWN;
             end
     end

  assign qa = (polar_qa === "INVERT")?~tmp_a:tmp_a;
  assign qb = (polar_qb === "INVERT")?~mem_data[muxed_address]:mem_data[muxed_address];
  assign busy = (polar_busy === "INVERT")?~tmp_busy:tmp_busy;

  //pragma translate_on
endmodule // csdpram
`ifdef SYNTH
`else
`endcelldefine
`endif
